/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.handler.AbstractHttpHandler;
import org.openqa.jetty.log.LogFactory;

public class NotFoundHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(NotFoundHandler.class);

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        log.debug("Not Found");
        String method = request.getMethod();
        if (method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("PUT") || method.equals("DELETE") || method.equals("MOVE")) {
            response.sendError(404, String.valueOf(request.getPath()) + " Not Found");
        } else if (method.equals("OPTIONS")) {
            if ("*".equals(request.getPath())) {
                response.setIntField("Content-Length", 0);
                response.setField("Allow", "GET, HEAD, POST, PUT, DELETE, MOVE, OPTIONS, TRACE");
                response.commit();
            } else {
                response.sendError(404);
            }
        } else if (method.equals("TRACE")) {
            this.handleTrace(request, response);
        } else {
            response.setField("Allow", "GET, HEAD, POST, PUT, DELETE, MOVE, OPTIONS, TRACE");
            response.sendError(405);
        }
    }
}

