/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum GridRole {
    NOT_GRID,
    HUB,
    NODE;

    private static List<String> rcAliases;
    private static List<String> wdAliases;
    private static List<String> nodeAliases;

    static {
        rcAliases = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add("rc")).add("remotecontrol")).add("remote-control")).build();
        wdAliases = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add("wd")).add("webdriver")).build();
        nodeAliases = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add("node")).addAll(rcAliases)).addAll(wdAliases)).build();
    }

    public static GridRole find(String[] args) {
        if (args == null) {
            return NOT_GRID;
        }
        int i = 0;
        while (i < args.length) {
            if ("-role".equals(args[i])) {
                if (i == args.length - 1) {
                    return null;
                }
                String role = args[i + 1].toLowerCase();
                if (nodeAliases.contains(role)) {
                    return NODE;
                }
                if ("hub".equals(role)) {
                    return HUB;
                }
                if ("standalone".equals(role)) {
                    return NOT_GRID;
                }
                return null;
            }
            ++i;
        }
        return NOT_GRID;
    }

    public static boolean isRC(String nodeType) {
        return rcAliases.contains(nodeType);
    }

    public static boolean isWebDriver(String nodeType) {
        return wdAliases.contains(nodeType);
    }
}

