/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.Worker;
import org.jboss.netty.channel.socket.oio.AbstractOioChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractOioWorker<C extends AbstractOioChannel>
implements Worker {
    private final Queue<Runnable> eventQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final C channel;
    protected volatile Thread thread;
    private volatile boolean done;

    public AbstractOioWorker(C channel) {
        this.channel = channel;
        ((AbstractOioChannel)channel).worker = this;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isIoThread(AbstractOioChannel channel) {
        return Thread.currentThread() == channel.workerThread;
    }

    @Override
    public void executeInIoThread(Runnable task) {
        if (Thread.currentThread() == this.thread || this.done) {
            task.run();
        } else {
            boolean added = this.eventQueue.offer(task);
            if (added) {
                // empty if block
            }
        }
    }

    private void processEventQueue() {
        Runnable task;
        while ((task = this.eventQueue.poll()) != null) {
            task.run();
        }
    }

    abstract boolean process() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(AbstractOioChannel channel, ChannelFuture future, int interestOps) {
        block12: {
            boolean iothread = AbstractOioWorker.isIoThread(channel);
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInterestOpsNow(1);
                    } else {
                        channel.setInterestOpsNow(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block12;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInterestOpsNow(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                if (iothread) {
                    Channels.fireChannelInterestChanged(channel);
                } else {
                    Channels.fireChannelInterestChangedLater(channel);
                }
            }
            catch (Throwable t) {
                future.setFailure(t);
                if (iothread) {
                    Channels.fireExceptionCaught(channel, t);
                }
                Channels.fireExceptionCaughtLater(channel, t);
            }
        }
    }

    static void close(AbstractOioChannel channel, ChannelFuture future) {
        AbstractOioWorker.close(channel, future, AbstractOioWorker.isIoThread(channel));
    }

    private static void close(AbstractOioChannel channel, ChannelFuture future, boolean iothread) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.closeSocket();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                    if (iothread) {
                        Channels.fireChannelDisconnected(channel);
                    } else {
                        Channels.fireChannelDisconnectedLater(channel);
                    }
                }
                if (bound) {
                    if (iothread) {
                        Channels.fireChannelUnbound(channel);
                    } else {
                        Channels.fireChannelUnboundLater(channel);
                    }
                }
                if (iothread) {
                    Channels.fireChannelClosed(channel);
                } else {
                    Channels.fireChannelClosedLater(channel);
                }
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }
}

